import 'dart:convert';

/// withlogin : 1
/// menu : {"id":3,"name":"TV Shows","slug":"tv-shows","position":3,"created_at":"2021-08-03T12:13:41.000000Z","updated_at":"2021-08-03T12:13:41.000000Z"}
/// subscribed : 1
/// top_data : {"id":3,"name":"TV Shows","slug":"tv-shows","position":3,"created_at":"2021-08-03T12:13:41.000000Z","updated_at":"2021-08-03T12:13:41.000000Z","menu_data":[{"id":152,"menu_id":3,"movie_id":0,"tv_series_id":1,"live_event_id":0,"audio_id":0,"created_at":"2022-05-10T03:46:06.000000Z","updated_at":"2022-05-10T03:46:06.000000Z","movie":{"id":18,"tmdb_id":592350,"title":"My Hero Academia: Heroes Rising","slug":"my-hero-academia-heroes-rising","keyword":"Animation, Action, Fantasy, Adventure","description":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","duration":"104","thumbnail":"tmdb_zGVbrulkupqpbwgiNedkJPyQum4.jpg","poster":"poster_9guoVF7zayiiUq5ulKQpt375VIy.jpg","tmdb":"Y","fetch_by":"title","director_id":"606,607,608,609,610","actor_id":"650,651,652,653,654","genre_id":"12,1,6,2","trailer_url":"https://youtu.be/ezHmHHt0B78","detail":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","views":0,"rating":8.25,"maturity_rating":"10+","subtitle":0,"publish_year":2019,"released":"2019-12-20","upload_video":null,"featured":0,"series":0,"a_language":"2","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IkgvRU1jNHh2NmdIekxWY2hSZ0JmVUE9PSIsInZhbHVlIjoiUVNFSTdvQlBpSFo0Zk5qa1BxQ3F1QT09IiwibWFjIjoiNThjY2M2OWZjNjkwNzY1NzI3ZjAyOTdmNjM3ZjE4NzQ4NjdmNjEwMzNjMzYxNzY2OTQwNWFlMDdhYTRiMDc3ZiIsInRhZyI6IiJ9","created_by":27,"created_at":"2021-08-04T12:03:13.000000Z","updated_at":"2022-12-02T02:02:24.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0},"tvseries":{"id":1,"keyword":"Animation, Sci-Fi & Fantasy","description":"Rick is a mentally-unbalanced but scientifically-gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","title":"Rick and Morty","tmdb_id":"60625","tmdb":"Y","fetch_by":"title","thumbnail":"tmdb_sGVCWtLG37mLOhl11qQVrjKsDzx.jpg","poster":"poster_8aCek7W6BovH7M4enWjqrGptvQ8.jpg","genre_id":"12,3,19,20","detail":"Rick is a mentally-unbalanced but scientifically gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","rating":8.8,"episode_runtime":null,"maturity_rating":"10+","featured":0,"type":"T","status":1,"created_by":1,"created_at":"2021-08-03T14:37:58.000000Z","updated_at":"2022-10-12T03:22:42.000000Z","is_custom_label":0,"label_id":null,"is_upcoming":0,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0,"seasons":[{"id":1,"tv_series_id":1,"tmdb_id":"60059","season_no":1,"season_slug":"rick-and-morty-season-1","tmdb":"Y","publish_year":"2013","thumbnail":"tmdb_pZoqbuJGaVM7vgzsSCPwRH5TCx5.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty visit a pawn shop in space, encounter various alternate and virtual realities, and meet the devil at his antique shop.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":null,"created_at":"2021-08-03T14:39:23.000000Z","updated_at":"2021-08-03T14:39:23.000000Z","is_custom_thumb":0},{"id":6,"tv_series_id":1,"tmdb_id":"66738","season_no":2,"season_slug":"rick-and-morty-season-2","tmdb":"Y","publish_year":"2015","thumbnail":"tmdb_zkhGdE29umuKwa6u6mm7e4cXvYY.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"After Rick and Morty decided to unfreeze time, they must deal with alien parasites, alternate Jerrys and a decaying, possibly non-existent dimension.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/7ecYoSvGO60","created_at":"2021-08-04T08:04:35.000000Z","updated_at":"2021-08-04T08:04:35.000000Z","is_custom_thumb":0},{"id":7,"tv_series_id":1,"tmdb_id":"86926","season_no":3,"season_slug":"rick-and-morty-season-3","tmdb":"Y","publish_year":"2017","thumbnail":"tmdb_lVcwMfbHx4QguLbZT4bink9mcgd.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty travel to Atlantis and take some time to relax, plus Rick turns himself into a pickle and faces off against the president.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/RLQPgnHhOjw","created_at":"2021-08-04T08:08:22.000000Z","updated_at":"2021-08-04T08:08:22.000000Z","is_custom_thumb":0}]}}]}

TopDataModel topDataModelFromJson(String str) =>
    TopDataModel.fromJson(json.decode(str));
String topDataModelToJson(TopDataModel data) => json.encode(data.toJson());

class TopDataModel {
  TopDataModel({
    this.withlogin,
    this.menu,
    this.subscribed,
    this.topData,
  });

  TopDataModel.fromJson(dynamic json) {
    withlogin = num.tryParse(json['withlogin'].toString());
    menu = json['menu'] != null ? Menu.fromJson(json['menu']) : null;
    subscribed = num.tryParse(json['subscribed'].toString());
    topData =
        json['top_data'] != null ? TopData.fromJson(json['top_data']) : null;
  }
  num? withlogin;
  Menu? menu;
  num? subscribed;
  TopData? topData;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['withlogin'] = withlogin;
    if (menu != null) {
      map['menu'] = menu?.toJson();
    }
    map['subscribed'] = subscribed;
    if (topData != null) {
      map['top_data'] = topData?.toJson();
    }
    return map;
  }
}

/// id : 3
/// name : "TV Shows"
/// slug : "tv-shows"
/// position : 3
/// created_at : "2021-08-03T12:13:41.000000Z"
/// updated_at : "2021-08-03T12:13:41.000000Z"
/// menu_data : [{"id":152,"menu_id":3,"movie_id":0,"tv_series_id":1,"live_event_id":0,"audio_id":0,"created_at":"2022-05-10T03:46:06.000000Z","updated_at":"2022-05-10T03:46:06.000000Z","movie":{"id":18,"tmdb_id":592350,"title":"My Hero Academia: Heroes Rising","slug":"my-hero-academia-heroes-rising","keyword":"Animation, Action, Fantasy, Adventure","description":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","duration":"104","thumbnail":"tmdb_zGVbrulkupqpbwgiNedkJPyQum4.jpg","poster":"poster_9guoVF7zayiiUq5ulKQpt375VIy.jpg","tmdb":"Y","fetch_by":"title","director_id":"606,607,608,609,610","actor_id":"650,651,652,653,654","genre_id":"12,1,6,2","trailer_url":"https://youtu.be/ezHmHHt0B78","detail":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","views":0,"rating":8.25,"maturity_rating":"10+","subtitle":0,"publish_year":2019,"released":"2019-12-20","upload_video":null,"featured":0,"series":0,"a_language":"2","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IkgvRU1jNHh2NmdIekxWY2hSZ0JmVUE9PSIsInZhbHVlIjoiUVNFSTdvQlBpSFo0Zk5qa1BxQ3F1QT09IiwibWFjIjoiNThjY2M2OWZjNjkwNzY1NzI3ZjAyOTdmNjM3ZjE4NzQ4NjdmNjEwMzNjMzYxNzY2OTQwNWFlMDdhYTRiMDc3ZiIsInRhZyI6IiJ9","created_by":27,"created_at":"2021-08-04T12:03:13.000000Z","updated_at":"2022-12-02T02:02:24.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0},"tvseries":{"id":1,"keyword":"Animation, Sci-Fi & Fantasy","description":"Rick is a mentally-unbalanced but scientifically-gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","title":"Rick and Morty","tmdb_id":"60625","tmdb":"Y","fetch_by":"title","thumbnail":"tmdb_sGVCWtLG37mLOhl11qQVrjKsDzx.jpg","poster":"poster_8aCek7W6BovH7M4enWjqrGptvQ8.jpg","genre_id":"12,3,19,20","detail":"Rick is a mentally-unbalanced but scientifically gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","rating":8.8,"episode_runtime":null,"maturity_rating":"10+","featured":0,"type":"T","status":1,"created_by":1,"created_at":"2021-08-03T14:37:58.000000Z","updated_at":"2022-10-12T03:22:42.000000Z","is_custom_label":0,"label_id":null,"is_upcoming":0,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0,"seasons":[{"id":1,"tv_series_id":1,"tmdb_id":"60059","season_no":1,"season_slug":"rick-and-morty-season-1","tmdb":"Y","publish_year":"2013","thumbnail":"tmdb_pZoqbuJGaVM7vgzsSCPwRH5TCx5.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty visit a pawn shop in space, encounter various alternate and virtual realities, and meet the devil at his antique shop.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":null,"created_at":"2021-08-03T14:39:23.000000Z","updated_at":"2021-08-03T14:39:23.000000Z","is_custom_thumb":0},{"id":6,"tv_series_id":1,"tmdb_id":"66738","season_no":2,"season_slug":"rick-and-morty-season-2","tmdb":"Y","publish_year":"2015","thumbnail":"tmdb_zkhGdE29umuKwa6u6mm7e4cXvYY.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"After Rick and Morty decided to unfreeze time, they must deal with alien parasites, alternate Jerrys and a decaying, possibly non-existent dimension.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/7ecYoSvGO60","created_at":"2021-08-04T08:04:35.000000Z","updated_at":"2021-08-04T08:04:35.000000Z","is_custom_thumb":0},{"id":7,"tv_series_id":1,"tmdb_id":"86926","season_no":3,"season_slug":"rick-and-morty-season-3","tmdb":"Y","publish_year":"2017","thumbnail":"tmdb_lVcwMfbHx4QguLbZT4bink9mcgd.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty travel to Atlantis and take some time to relax, plus Rick turns himself into a pickle and faces off against the president.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/RLQPgnHhOjw","created_at":"2021-08-04T08:08:22.000000Z","updated_at":"2021-08-04T08:08:22.000000Z","is_custom_thumb":0}]}}]

TopData topDataFromJson(String str) => TopData.fromJson(json.decode(str));
String topDataToJson(TopData data) => json.encode(data.toJson());

class TopData {
  TopData({
    this.id,
    this.name,
    this.slug,
    this.position,
    this.createdAt,
    this.updatedAt,
    this.menuData,
  });

  TopData.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    name = json['name'];
    slug = json['slug'];
    position = num.tryParse(json['position'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    if (json['menu_data'] != null) {
      menuData = [];
      json['menu_data'].forEach((v) {
        menuData?.add(MenuData.fromJson(v));
      });
    }
  }
  num? id;
  String? name;
  String? slug;
  num? position;
  String? createdAt;
  String? updatedAt;
  List<MenuData>? menuData;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['slug'] = slug;
    map['position'] = position;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    if (menuData != null) {
      map['menu_data'] = menuData?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// id : 152
/// menu_id : 3
/// movie_id : 0
/// tv_series_id : 1
/// live_event_id : 0
/// audio_id : 0
/// created_at : "2022-05-10T03:46:06.000000Z"
/// updated_at : "2022-05-10T03:46:06.000000Z"
/// movie : {"id":18,"tmdb_id":592350,"title":"My Hero Academia: Heroes Rising","slug":"my-hero-academia-heroes-rising","keyword":"Animation, Action, Fantasy, Adventure","description":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","duration":"104","thumbnail":"tmdb_zGVbrulkupqpbwgiNedkJPyQum4.jpg","poster":"poster_9guoVF7zayiiUq5ulKQpt375VIy.jpg","tmdb":"Y","fetch_by":"title","director_id":"606,607,608,609,610","actor_id":"650,651,652,653,654","genre_id":"12,1,6,2","trailer_url":"https://youtu.be/ezHmHHt0B78","detail":"Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope.","views":0,"rating":8.25,"maturity_rating":"10+","subtitle":0,"publish_year":2019,"released":"2019-12-20","upload_video":null,"featured":0,"series":0,"a_language":"2","audio_files":null,"type":"M","live":0,"livetvicon":null,"status":1,"is_protect":0,"password":"eyJpdiI6IkgvRU1jNHh2NmdIekxWY2hSZ0JmVUE9PSIsInZhbHVlIjoiUVNFSTdvQlBpSFo0Zk5qa1BxQ3F1QT09IiwibWFjIjoiNThjY2M2OWZjNjkwNzY1NzI3ZjAyOTdmNjM3ZjE4NzQ4NjdmNjEwMzNjMzYxNzY2OTQwNWFlMDdhYTRiMDc3ZiIsInRhZyI6IiJ9","created_by":27,"created_at":"2021-08-04T12:03:13.000000Z","updated_at":"2022-12-02T02:02:24.000000Z","is_upcoming":0,"is_custom_label":0,"label_id":null,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0}
/// tvseries : {"id":1,"keyword":"Animation, Sci-Fi & Fantasy","description":"Rick is a mentally-unbalanced but scientifically-gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","title":"Rick and Morty","tmdb_id":"60625","tmdb":"Y","fetch_by":"title","thumbnail":"tmdb_sGVCWtLG37mLOhl11qQVrjKsDzx.jpg","poster":"poster_8aCek7W6BovH7M4enWjqrGptvQ8.jpg","genre_id":"12,3,19,20","detail":"Rick is a mentally-unbalanced but scientifically gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school.","rating":8.8,"episode_runtime":null,"maturity_rating":"10+","featured":0,"type":"T","status":1,"created_by":1,"created_at":"2021-08-03T14:37:58.000000Z","updated_at":"2022-10-12T03:22:42.000000Z","is_custom_label":0,"label_id":null,"is_upcoming":0,"upcoming_date":null,"is_kids":1,"country":0,"is_custom_thumb":0,"user-rating":0,"seasons":[{"id":1,"tv_series_id":1,"tmdb_id":"60059","season_no":1,"season_slug":"rick-and-morty-season-1","tmdb":"Y","publish_year":"2013","thumbnail":"tmdb_pZoqbuJGaVM7vgzsSCPwRH5TCx5.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty visit a pawn shop in space, encounter various alternate and virtual realities, and meet the devil at his antique shop.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":null,"created_at":"2021-08-03T14:39:23.000000Z","updated_at":"2021-08-03T14:39:23.000000Z","is_custom_thumb":0},{"id":6,"tv_series_id":1,"tmdb_id":"66738","season_no":2,"season_slug":"rick-and-morty-season-2","tmdb":"Y","publish_year":"2015","thumbnail":"tmdb_zkhGdE29umuKwa6u6mm7e4cXvYY.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"After Rick and Morty decided to unfreeze time, they must deal with alien parasites, alternate Jerrys and a decaying, possibly non-existent dimension.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/7ecYoSvGO60","created_at":"2021-08-04T08:04:35.000000Z","updated_at":"2021-08-04T08:04:35.000000Z","is_custom_thumb":0},{"id":7,"tv_series_id":1,"tmdb_id":"86926","season_no":3,"season_slug":"rick-and-morty-season-3","tmdb":"Y","publish_year":"2017","thumbnail":"tmdb_lVcwMfbHx4QguLbZT4bink9mcgd.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty travel to Atlantis and take some time to relax, plus Rick turns himself into a pickle and faces off against the president.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/RLQPgnHhOjw","created_at":"2021-08-04T08:08:22.000000Z","updated_at":"2021-08-04T08:08:22.000000Z","is_custom_thumb":0}]}

MenuData menuDataFromJson(String str) => MenuData.fromJson(json.decode(str));
String menuDataToJson(MenuData data) => json.encode(data.toJson());

class MenuData {
  MenuData({
    this.id,
    this.menuId,
    this.movieId,
    this.tvSeriesId,
    this.liveEventId,
    this.audioId,
    this.createdAt,
    this.updatedAt,
    this.movie,
    this.tvseries,
  });

  MenuData.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    menuId = num.tryParse(json['menu_id'].toString());
    movieId = num.tryParse(json['movie_id'].toString());
    tvSeriesId = num.tryParse(json['tv_series_id'].toString());
    liveEventId = num.tryParse(json['live_event_id'].toString());
    audioId = num.tryParse(json['audio_id'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    movie = json['movie'] != null ? Movie.fromJson(json['movie']) : null;
    tvseries =
        json['tvseries'] != null ? Tvseries.fromJson(json['tvseries']) : null;
  }
  num? id;
  num? menuId;
  num? movieId;
  num? tvSeriesId;
  num? liveEventId;
  num? audioId;
  String? createdAt;
  String? updatedAt;
  Movie? movie;
  Tvseries? tvseries;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['menu_id'] = menuId;
    map['movie_id'] = movieId;
    map['tv_series_id'] = tvSeriesId;
    map['live_event_id'] = liveEventId;
    map['audio_id'] = audioId;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    if (movie != null) {
      map['movie'] = movie?.toJson();
    }
    if (tvseries != null) {
      map['tvseries'] = tvseries?.toJson();
    }
    return map;
  }
}

/// id : 1
/// keyword : "Animation, Sci-Fi & Fantasy"
/// description : "Rick is a mentally-unbalanced but scientifically-gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school."
/// title : "Rick and Morty"
/// tmdb_id : "60625"
/// tmdb : "Y"
/// fetch_by : "title"
/// thumbnail : "tmdb_sGVCWtLG37mLOhl11qQVrjKsDzx.jpg"
/// poster : "poster_8aCek7W6BovH7M4enWjqrGptvQ8.jpg"
/// genre_id : "12,3,19,20"
/// detail : "Rick is a mentally-unbalanced but scientifically gifted old man who has recently reconnected with his family. He spends most of his time involving his young grandson Morty in dangerous, outlandish adventures throughout space and alternate universes. Compounded with Morty's already unstable family life, these events cause Morty much distress at home and school."
/// rating : 8.8
/// episode_runtime : null
/// maturity_rating : "10+"
/// featured : 0
/// type : "T"
/// status : 1
/// created_by : 1
/// created_at : "2021-08-03T14:37:58.000000Z"
/// updated_at : "2022-10-12T03:22:42.000000Z"
/// is_custom_label : 0
/// label_id : null
/// is_upcoming : 0
/// upcoming_date : null
/// is_kids : 1
/// country : 0
/// is_custom_thumb : 0
/// user-rating : 0
/// seasons : [{"id":1,"tv_series_id":1,"tmdb_id":"60059","season_no":1,"season_slug":"rick-and-morty-season-1","tmdb":"Y","publish_year":"2013","thumbnail":"tmdb_pZoqbuJGaVM7vgzsSCPwRH5TCx5.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty visit a pawn shop in space, encounter various alternate and virtual realities, and meet the devil at his antique shop.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":null,"created_at":"2021-08-03T14:39:23.000000Z","updated_at":"2021-08-03T14:39:23.000000Z","is_custom_thumb":0},{"id":6,"tv_series_id":1,"tmdb_id":"66738","season_no":2,"season_slug":"rick-and-morty-season-2","tmdb":"Y","publish_year":"2015","thumbnail":"tmdb_zkhGdE29umuKwa6u6mm7e4cXvYY.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"After Rick and Morty decided to unfreeze time, they must deal with alien parasites, alternate Jerrys and a decaying, possibly non-existent dimension.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/7ecYoSvGO60","created_at":"2021-08-04T08:04:35.000000Z","updated_at":"2021-08-04T08:04:35.000000Z","is_custom_thumb":0},{"id":7,"tv_series_id":1,"tmdb_id":"86926","season_no":3,"season_slug":"rick-and-morty-season-3","tmdb":"Y","publish_year":"2017","thumbnail":"tmdb_lVcwMfbHx4QguLbZT4bink9mcgd.jpg","poster":null,"actor_id":"80,81,82,83","a_language":"1","detail":"Rick and Morty travel to Atlantis and take some time to relax, plus Rick turns himself into a pickle and faces off against the president.","views":0,"featured":0,"type":"S","is_protect":0,"password":null,"trailer_url":"https://youtu.be/RLQPgnHhOjw","created_at":"2021-08-04T08:08:22.000000Z","updated_at":"2021-08-04T08:08:22.000000Z","is_custom_thumb":0}]

Tvseries tvseriesFromJson(String str) => Tvseries.fromJson(json.decode(str));
String tvseriesToJson(Tvseries data) => json.encode(data.toJson());

class Tvseries {
  Tvseries({
    this.id,
    this.keyword,
    this.description,
    this.title,
    this.tmdbId,
    this.tmdb,
    this.fetchBy,
    this.thumbnail,
    this.poster,
    this.genreId,
    this.detail,
    this.rating,
    this.episodeRuntime,
    this.maturityRating,
    this.featured,
    this.type,
    this.status,
    this.createdBy,
    this.createdAt,
    this.updatedAt,
    this.isCustomLabel,
    this.labelId,
    this.isUpcoming,
    this.upcomingDate,
    this.isKids,
    this.country,
    this.isCustomThumb,
    this.userrating,
    this.seasons,
  });

  Tvseries.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    keyword = json['keyword'];
    description = json['description'];
    title = json['title'];
    tmdbId = json['tmdb_id'];
    tmdb = json['tmdb'];
    fetchBy = json['fetch_by'];
    thumbnail = json['thumbnail'];
    poster = json['poster'];
    genreId = json['genre_id'];
    detail = json['detail'];
    rating = num.tryParse(json['rating'].toString());
    episodeRuntime = json['episode_runtime'];
    maturityRating = json['maturity_rating'];
    featured = num.tryParse(json['featured'].toString());
    type = json['type'];
    status = num.tryParse(json['status'].toString());
    createdBy = num.tryParse(json['created_by'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    isCustomLabel = num.tryParse(json['is_custom_label'].toString());
    labelId = json['label_id'];
    isUpcoming = num.tryParse(json['is_upcoming'].toString());
    upcomingDate = json['upcoming_date'];
    isKids = num.tryParse(json['is_kids'].toString());
    country = num.tryParse(json['country'].toString());
    isCustomThumb = num.tryParse(json['is_custom_thumb'].toString());
    userrating = num.tryParse(json['user-rating'].toString());
    if (json['seasons'] != null) {
      seasons = [];
      json['seasons'].forEach((v) {
        seasons?.add(Seasons.fromJson(v));
      });
    }
  }
  num? id;
  String? keyword;
  String? description;
  String? title;
  String? tmdbId;
  String? tmdb;
  String? fetchBy;
  String? thumbnail;
  String? poster;
  String? genreId;
  String? detail;
  num? rating;
  dynamic episodeRuntime;
  String? maturityRating;
  num? featured;
  String? type;
  num? status;
  num? createdBy;
  String? createdAt;
  String? updatedAt;
  num? isCustomLabel;
  dynamic labelId;
  num? isUpcoming;
  dynamic upcomingDate;
  num? isKids;
  num? country;
  num? isCustomThumb;
  num? userrating;
  List<Seasons>? seasons;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['keyword'] = keyword;
    map['description'] = description;
    map['title'] = title;
    map['tmdb_id'] = tmdbId;
    map['tmdb'] = tmdb;
    map['fetch_by'] = fetchBy;
    map['thumbnail'] = thumbnail;
    map['poster'] = poster;
    map['genre_id'] = genreId;
    map['detail'] = detail;
    map['rating'] = rating;
    map['episode_runtime'] = episodeRuntime;
    map['maturity_rating'] = maturityRating;
    map['featured'] = featured;
    map['type'] = type;
    map['status'] = status;
    map['created_by'] = createdBy;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    map['is_custom_label'] = isCustomLabel;
    map['label_id'] = labelId;
    map['is_upcoming'] = isUpcoming;
    map['upcoming_date'] = upcomingDate;
    map['is_kids'] = isKids;
    map['country'] = country;
    map['is_custom_thumb'] = isCustomThumb;
    map['user-rating'] = userrating;
    if (seasons != null) {
      map['seasons'] = seasons?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// id : 1
/// tv_series_id : 1
/// tmdb_id : "60059"
/// season_no : 1
/// season_slug : "rick-and-morty-season-1"
/// tmdb : "Y"
/// publish_year : "2013"
/// thumbnail : "tmdb_pZoqbuJGaVM7vgzsSCPwRH5TCx5.jpg"
/// poster : null
/// actor_id : "80,81,82,83"
/// a_language : "1"
/// detail : "Rick and Morty visit a pawn shop in space, encounter various alternate and virtual realities, and meet the devil at his antique shop."
/// views : 0
/// featured : 0
/// type : "S"
/// is_protect : 0
/// password : null
/// trailer_url : null
/// created_at : "2021-08-03T14:39:23.000000Z"
/// updated_at : "2021-08-03T14:39:23.000000Z"
/// is_custom_thumb : 0

Seasons seasonsFromJson(String str) => Seasons.fromJson(json.decode(str));
String seasonsToJson(Seasons data) => json.encode(data.toJson());

class Seasons {
  Seasons({
    this.id,
    this.tvSeriesId,
    this.tmdbId,
    this.seasonNo,
    this.seasonSlug,
    this.tmdb,
    this.publishYear,
    this.thumbnail,
    this.poster,
    this.actorId,
    this.aLanguage,
    this.detail,
    this.views,
    this.featured,
    this.type,
    this.isProtect,
    this.password,
    this.trailerUrl,
    this.createdAt,
    this.updatedAt,
    this.isCustomThumb,
  });

  Seasons.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    tvSeriesId = num.tryParse(json['tv_series_id'].toString());
    tmdbId = json['tmdb_id'];
    seasonNo = num.tryParse(json['season_no'].toString());
    seasonSlug = json['season_slug'];
    tmdb = json['tmdb'];
    publishYear = json['publish_year'];
    thumbnail = json['thumbnail'];
    poster = json['poster'];
    actorId = json['actor_id'];
    aLanguage = json['a_language'];
    detail = json['detail'];
    views = num.tryParse(json['views'].toString());
    featured = num.tryParse(json['featured'].toString());
    type = json['type'];
    isProtect = num.tryParse(json['is_protect'].toString());
    password = json['password'];
    trailerUrl = json['trailer_url'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    isCustomThumb = num.tryParse(json['is_custom_thumb'].toString());
  }
  num? id;
  num? tvSeriesId;
  String? tmdbId;
  num? seasonNo;
  String? seasonSlug;
  String? tmdb;
  String? publishYear;
  String? thumbnail;
  dynamic poster;
  String? actorId;
  String? aLanguage;
  String? detail;
  num? views;
  num? featured;
  String? type;
  num? isProtect;
  dynamic password;
  dynamic trailerUrl;
  String? createdAt;
  String? updatedAt;
  num? isCustomThumb;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['tv_series_id'] = tvSeriesId;
    map['tmdb_id'] = tmdbId;
    map['season_no'] = seasonNo;
    map['season_slug'] = seasonSlug;
    map['tmdb'] = tmdb;
    map['publish_year'] = publishYear;
    map['thumbnail'] = thumbnail;
    map['poster'] = poster;
    map['actor_id'] = actorId;
    map['a_language'] = aLanguage;
    map['detail'] = detail;
    map['views'] = views;
    map['featured'] = featured;
    map['type'] = type;
    map['is_protect'] = isProtect;
    map['password'] = password;
    map['trailer_url'] = trailerUrl;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    map['is_custom_thumb'] = isCustomThumb;
    return map;
  }
}

/// id : 18
/// tmdb_id : 592350
/// title : "My Hero Academia: Heroes Rising"
/// slug : "my-hero-academia-heroes-rising"
/// keyword : "Animation, Action, Fantasy, Adventure"
/// description : "Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope."
/// duration : "104"
/// thumbnail : "tmdb_zGVbrulkupqpbwgiNedkJPyQum4.jpg"
/// poster : "poster_9guoVF7zayiiUq5ulKQpt375VIy.jpg"
/// tmdb : "Y"
/// fetch_by : "title"
/// director_id : "606,607,608,609,610"
/// actor_id : "650,651,652,653,654"
/// genre_id : "12,1,6,2"
/// trailer_url : "https://youtu.be/ezHmHHt0B78"
/// detail : "Class 1-A visits Nabu Island where they finally get to do some real hero work. The place is so peaceful that it's more like a vacation … until they're attacked by a villain with an unfathomable Quirk! His power is eerily familiar, and it looks like Shigaraki had a hand in the plan. But with All Might retired and citizens' lives on the line, there's no time for questions. Deku and his friends are the next generation of heroes, and they're the island's only hope."
/// views : 0
/// rating : 8.25
/// maturity_rating : "10+"
/// subtitle : 0
/// publish_year : 2019
/// released : "2019-12-20"
/// upload_video : null
/// featured : 0
/// series : 0
/// a_language : "2"
/// audio_files : null
/// type : "M"
/// live : 0
/// livetvicon : null
/// status : 1
/// is_protect : 0
/// password : "eyJpdiI6IkgvRU1jNHh2NmdIekxWY2hSZ0JmVUE9PSIsInZhbHVlIjoiUVNFSTdvQlBpSFo0Zk5qa1BxQ3F1QT09IiwibWFjIjoiNThjY2M2OWZjNjkwNzY1NzI3ZjAyOTdmNjM3ZjE4NzQ4NjdmNjEwMzNjMzYxNzY2OTQwNWFlMDdhYTRiMDc3ZiIsInRhZyI6IiJ9"
/// created_by : 27
/// created_at : "2021-08-04T12:03:13.000000Z"
/// updated_at : "2022-12-02T02:02:24.000000Z"
/// is_upcoming : 0
/// is_custom_label : 0
/// label_id : null
/// upcoming_date : null
/// is_kids : 1
/// country : 0
/// is_custom_thumb : 0
/// user-rating : 0

Movie movieFromJson(String str) => Movie.fromJson(json.decode(str));
String movieToJson(Movie data) => json.encode(data.toJson());

class Movie {
  Movie({
    this.id,
    this.tmdbId,
    this.title,
    this.slug,
    this.keyword,
    this.description,
    this.duration,
    this.thumbnail,
    this.poster,
    this.tmdb,
    this.fetchBy,
    this.directorId,
    this.actorId,
    this.genreId,
    this.trailerUrl,
    this.detail,
    this.views,
    this.rating,
    this.maturityRating,
    this.subtitle,
    this.publishYear,
    this.released,
    this.uploadVideo,
    this.featured,
    this.series,
    this.aLanguage,
    this.audioFiles,
    this.type,
    this.live,
    this.livetvicon,
    this.status,
    this.isProtect,
    this.password,
    this.createdBy,
    this.createdAt,
    this.updatedAt,
    this.isUpcoming,
    this.isCustomLabel,
    this.labelId,
    this.upcomingDate,
    this.isKids,
    this.country,
    this.isCustomThumb,
    this.userrating,
  });

  Movie.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    tmdbId = num.tryParse(json['tmdb_id'].toString());
    title = json['title'];
    slug = json['slug'];
    keyword = json['keyword'];
    description = json['description'];
    duration = json['duration'];
    thumbnail = json['thumbnail'];
    poster = json['poster'];
    tmdb = json['tmdb'];
    fetchBy = json['fetch_by'];
    directorId = json['director_id'];
    actorId = json['actor_id'];
    genreId = json['genre_id'];
    trailerUrl = json['trailer_url'];
    detail = json['detail'];
    views = num.tryParse(json['views'].toString());
    rating = num.tryParse(json['rating'].toString());
    maturityRating = json['maturity_rating'];
    subtitle = num.tryParse(json['subtitle'].toString());
    publishYear = num.tryParse(json['publish_year'].toString());
    released = json['released'];
    uploadVideo = json['upload_video'];
    featured = num.tryParse(json['featured'].toString());
    series = num.tryParse(json['series'].toString());
    aLanguage = json['a_language'];
    audioFiles = json['audio_files'];
    type = json['type'];
    live = num.tryParse(json['live'].toString());
    livetvicon = json['livetvicon'];
    status = num.tryParse(json['status'].toString());
    isProtect = num.tryParse(json['is_protect'].toString());
    password = json['password'];
    createdBy = num.tryParse(json['created_by'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    isUpcoming = num.tryParse(json['is_upcoming'].toString());
    isCustomLabel = num.tryParse(json['is_custom_label'].toString());
    labelId = json['label_id'];
    upcomingDate = json['upcoming_date'];
    isKids = num.tryParse(json['is_kids'].toString());
    country = num.tryParse(json['country'].toString());
    isCustomThumb = num.tryParse(json['is_custom_thumb'].toString());
    userrating = num.tryParse(json['user-rating'].toString());
  }
  num? id;
  num? tmdbId;
  String? title;
  String? slug;
  String? keyword;
  String? description;
  String? duration;
  String? thumbnail;
  String? poster;
  String? tmdb;
  String? fetchBy;
  String? directorId;
  String? actorId;
  String? genreId;
  String? trailerUrl;
  String? detail;
  num? views;
  num? rating;
  String? maturityRating;
  num? subtitle;
  num? publishYear;
  String? released;
  dynamic uploadVideo;
  num? featured;
  num? series;
  String? aLanguage;
  dynamic audioFiles;
  String? type;
  num? live;
  dynamic livetvicon;
  num? status;
  num? isProtect;
  String? password;
  num? createdBy;
  String? createdAt;
  String? updatedAt;
  num? isUpcoming;
  num? isCustomLabel;
  dynamic labelId;
  dynamic upcomingDate;
  num? isKids;
  num? country;
  num? isCustomThumb;
  num? userrating;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['tmdb_id'] = tmdbId;
    map['title'] = title;
    map['slug'] = slug;
    map['keyword'] = keyword;
    map['description'] = description;
    map['duration'] = duration;
    map['thumbnail'] = thumbnail;
    map['poster'] = poster;
    map['tmdb'] = tmdb;
    map['fetch_by'] = fetchBy;
    map['director_id'] = directorId;
    map['actor_id'] = actorId;
    map['genre_id'] = genreId;
    map['trailer_url'] = trailerUrl;
    map['detail'] = detail;
    map['views'] = views;
    map['rating'] = rating;
    map['maturity_rating'] = maturityRating;
    map['subtitle'] = subtitle;
    map['publish_year'] = publishYear;
    map['released'] = released;
    map['upload_video'] = uploadVideo;
    map['featured'] = featured;
    map['series'] = series;
    map['a_language'] = aLanguage;
    map['audio_files'] = audioFiles;
    map['type'] = type;
    map['live'] = live;
    map['livetvicon'] = livetvicon;
    map['status'] = status;
    map['is_protect'] = isProtect;
    map['password'] = password;
    map['created_by'] = createdBy;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    map['is_upcoming'] = isUpcoming;
    map['is_custom_label'] = isCustomLabel;
    map['label_id'] = labelId;
    map['upcoming_date'] = upcomingDate;
    map['is_kids'] = isKids;
    map['country'] = country;
    map['is_custom_thumb'] = isCustomThumb;
    map['user-rating'] = userrating;
    return map;
  }
}

/// id : 3
/// name : "TV Shows"
/// slug : "tv-shows"
/// position : 3
/// created_at : "2021-08-03T12:13:41.000000Z"
/// updated_at : "2021-08-03T12:13:41.000000Z"

Menu menuFromJson(String str) => Menu.fromJson(json.decode(str));
String menuToJson(Menu data) => json.encode(data.toJson());

class Menu {
  Menu({
    this.id,
    this.name,
    this.slug,
    this.position,
    this.createdAt,
    this.updatedAt,
  });

  Menu.fromJson(dynamic json) {
    id = num.tryParse(json['id'].toString());
    name = json['name'];
    slug = json['slug'];
    position = num.tryParse(json['position'].toString());
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
  num? id;
  String? name;
  String? slug;
  num? position;
  String? createdAt;
  String? updatedAt;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['slug'] = slug;
    map['position'] = position;
    map['created_at'] = createdAt;
    map['updated_at'] = updatedAt;
    return map;
  }
}
